/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.plainsmobs.entity;

import com.lycanitesmobs.ExtendedEntity;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.config.ConfigBase;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIBeg;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityRoc
extends EntityCreatureRideable
implements IMob,
IGroupHunter {
    public EntityAIAttackMelee attackAI;
    public boolean creeperDropping = true;
    private int creeperDropCooldown = 0;

    public EntityRoc(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 7;
        this.hasAttackSound = true;
        this.flySoundSpeed = 20;
        this.creeperDropping = ConfigBase.getConfig(this.group, "general").getBool("Features", "Roc Creeper Dropping", this.creeperDropping, "Set to false to prevent Rocs from picking up Creepers to drop on their victims!");
        this.setWidth = 0.8f;
        this.setHeight = 1.8f;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPlayerControl(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("roctreat"))).setTemptDistanceMin(4.0));
        this.attackAI = new EntityAIAttackMelee(this).setLongMemory(false);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.attackAI);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this).setPauseRate(0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIBeg(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityCreeper.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.42);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 48.0);
        baseAttributes.put("attackDamage", 2.0);
        baseAttributes.put("attackSpeed", 4.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151008_G), 1.0f).setMinAmount(3).setMaxAmount(5));
        this.drops.add(new DropRate(new ItemStack(Items.field_151103_aS), 0.75f).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null) {
            this.attackAI.setEnabled(this.hasPickupEntity() ? this.getPickupEntity() instanceof EntityCreeper : this.creeperDropCooldown <= 0);
            if (this.creeperDropCooldown > 0) {
                --this.creeperDropCooldown;
            }
            if (this.hasPickupEntity()) {
                double distance;
                ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(this.getPickupEntity());
                if (extendedEntity != null) {
                    extendedEntity.setPickedUpByEntity((Entity)this);
                }
                if (this.getPickupEntity() instanceof EntityCreeper && this.hasAttackTarget() && !(this.func_70638_az() instanceof EntityCreeper) && (distance = new Vec3d(this.field_70165_t, 0.0, this.field_70161_v).func_72438_d(new Vec3d(this.func_70638_az().field_70165_t, 0.0, this.func_70638_az().field_70161_v))) <= 2.0 && this.field_70163_u > this.func_70638_az().field_70163_u) {
                    this.getPickupEntity().func_70604_c(this.func_70638_az());
                    this.dropPickupEntity();
                    this.creeperDropCooldown = 120;
                }
                if (this.hasPickupEntity() && this.field_70173_aa % 100 == 0 && this.func_70681_au().nextBoolean()) {
                    if (this.getPickupEntity() instanceof EntityPlayer) {
                        for (int distToGround = 0; distToGround < 8; ++distToGround) {
                            Block searchBlock = this.func_130014_f_().func_180495_p(new BlockPos((int)this.field_70165_t, (int)this.field_70163_u - distToGround, (int)this.field_70161_v)).func_177230_c();
                            if (searchBlock == null || searchBlock == Blocks.field_150350_a) continue;
                            this.dropPickupEntity();
                            this.leap(1.0, 2.0);
                            break;
                        }
                    } else if (!(this.getPickupEntity() instanceof EntityCreeper)) {
                        this.dropPickupEntity();
                    }
                }
            } else if (this.hasAttackTarget() && !this.hasPickupEntity() && this.func_70068_e((Entity)this.func_70638_az()) > 2.0 && this.func_70681_au().nextInt(20) == 0) {
                if (this.field_70163_u - 1.0 > this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, -1.0, (Entity)this.func_70638_az());
                } else if (this.field_70163_u + 1.0 < this.func_70638_az().field_70163_u) {
                    this.leap(6.0f, 1.0, (Entity)this.func_70638_az());
                } else {
                    this.leap(6.0f, 0.0, (Entity)this.func_70638_az());
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.func_184179_bs() == null && this.getPickupEntity() instanceof EntityCreeper) {
            ((EntityCreeper)this.getPickupEntity()).func_70624_b(null);
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_76437_t)) {
            rider.func_184589_d(MobEffects.field_76437_t);
        }
        if (rider.func_70644_a(MobEffects.field_76419_f)) {
            rider.func_184589_d(MobEffects.field_76419_f);
        }
    }

    @Override
    public double getFlightOffset() {
        if (this.hasPickupEntity()) {
            return 5.0;
        }
        return super.getFlightOffset();
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entityLivingBase = (EntityLivingBase)target;
            if (this.canPickupEntity(entityLivingBase)) {
                this.pickupEntity(entityLivingBase);
            }
            if (entityLivingBase instanceof EntityCreeper) {
                entityLivingBase.func_70604_c(null);
                ((EntityCreeper)entityLivingBase).func_70624_b(null);
                this.func_70624_b(null);
            }
        }
        return true;
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(targetEntity);
        if (extendedEntity != null && extendedEntity.pickedUpByEntity != null) {
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (!this.creeperDropping && targetClass == EntityCreeper.class) {
            return false;
        }
        if (this.hasPickupEntity() && targetClass == EntityCreeper.class) {
            return false;
        }
        if (this.creeperDropCooldown > 0) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public void pickupEntity(EntityLivingBase entity) {
        super.pickupEntity(entity);
        if (this.field_70170_p.func_180495_p(this.func_180425_c()) != null && this.field_70170_p.func_175710_j(this.func_180425_c())) {
            this.leap(1.0, 2.0);
        }
    }

    @Override
    public double[] getPickupOffset(Entity entity) {
        return new double[]{0.0, -1.0, 0.0};
    }

    @Override
    public boolean canPickupEntity(EntityLivingBase entity) {
        if (this.creeperDropCooldown > 0 || this.hasPickupEntity()) {
            return false;
        }
        return super.canPickupEntity(entity);
    }

    @Override
    public boolean petControlsEnabled() {
        return false;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76419_f) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }

    @Override
    public BlockPos getWanderPosition(BlockPos wanderPosition) {
        if (this.hasPickupEntity() && this.getPickupEntity() instanceof EntityPlayer) {
            wanderPosition = new BlockPos(wanderPosition.func_177958_n(), this.restrictYHeightFromGround(wanderPosition, 6, 14), wanderPosition.func_177952_p());
        }
        return wanderPosition;
    }

    @Override
    public boolean isTamingItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ObjectManager.getItem("roctreat");
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.9;
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.func_130014_f_().field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.hasPickupEntity()) {
            if (this.getPickupEntity() instanceof EntityCreeper) {
                ((EntityCreeper)this.getPickupEntity()).func_146079_cb();
            }
            this.dropPickupEntity();
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        EntityLivingBase nearestTarget = this.getNearestEntity(EntityLivingBase.class, null, 4.0, true);
        if (this.canPickupEntity(nearestTarget)) {
            this.pickupEntity(nearestTarget);
        }
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }
}

